import groovy.json.JsonSlurper

import java.net.http.HttpClient

class OpenAIPromptHandler {
    public static beginPrompt (String systemPrompt, Float temperature) {
        def messageData = [
            ['role': 'system', 'content': systemPrompt],
        ]

        return OpenAIPromptHandler.beginPrompt(messageData, temperature)
    }

    public static beginPrompt (String systemPrompt, String userInput, Float temperature) {
        def messageData = [
            ['role': 'system', 'content': systemPrompt],
            ['role': 'user', 'content': userInput],
        ]

        return OpenAIPromptHandler.beginPrompt(messageData, temperature)
    }

    public static beginPrompt (ArrayList messageData, Float temperature) {
        def httpClient = HttpClient.newHttpClient()
        def jsonSlurper = new JsonSlurper()

        def chunkingConsumer = new OpenAISSEChunkingConsumer(jsonSlurper)
        OpenAiConnectionHandler.chat([messages: messageData, temperature: temperature], httpClient, jsonSlurper, chunkingConsumer.getChunkingConsumer())
        return chunkingConsumer
    }
}